//
//  UIImage+TwitchKit.m
//  Twitch Plugin
//
//  Created by Auston Stewart on 1/22/14.
//  Copyright (c) 2014 Justin.tv, Inc. All rights reserved.
//

#import "UIImage+TwitchKit.h"
#import "TwitchKit.h"

@implementation UIImage (TwitchKit)

+ (UIImage *)imageFromFrameworkBundleNamed:(NSString *)imageName
{
	NSBundle *frameworkBundle = [NSBundle bundleWithPath:[[NSBundle mainBundle] pathForResource:@"TwitchKit" ofType:@"bundle"]];
	NSString *imagePath = [frameworkBundle pathForResource:[UIScreen mainScreen].scale > 1.f ? [NSString stringWithFormat:@"%@@2x",imageName] : imageName ofType:@"png"];
	return [UIImage imageWithContentsOfFile:imagePath];
}

@end
